//=============================================================================
// SoR_MapBGM_EventSwitch_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.30 (2022/09/12)
//=============================================================================
/*:ja
@plugindesc ＜条件付きマップBGM変更＞ v1.30
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@help 指定条件式に応じて、各マップにおけるデフォルト再生BGMを
切り替えられるようになります。
「ストーリー中のある一定場面のみ、そのマップのBGMを変える」という
ゲーム上の演出が自然に実行可能です。

マップ設定のメモ欄に指定タグを記述してBGM変更を行います。
１つのマップに複数のタグを列挙することができます。
例：ゲーム内時間等に応じて、朝・昼・夜と別々のBGMを再生する

複数のBGM変更タグが条件を満たしている場合は、
メモのより上の方に書かれているタグが優先されます。
（再生優先度が高い条件のタグをより上部へ記述するようにしてください。)

@param DefaultVolume
@desc タグでボリューム指定がない場合のボリューム値 (default: 90)
@default 90
@type number
@min 0
@max 100
@param DefaultPitch
@desc タグでボリューム指定がない場合のピッチ値 (default: 100)
@default 100
@type number
@min 50
@max 150
@param DefaultPan
@desc タグでボリューム指定がない場合のパン値 (default: 0)
@default 0
@type number
@min -50
@max 50
@param DefaultPos
@desc タグでボリューム指定がない場合の再生開始値 (default: 0)
@default 0
@type number
@min 0
*/
/*:
@plugindesc <Conditional BGM switch on Map> v1.30
@author Soryu
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help This plugin enable us to switch default MAP BGM 
by given conditional branches. We can use different BGMs for the map
based on each situation without any strange transition.

We change BGMs by writing a note tag in the map where you want to change BGM.
We can enumerate several "mapswitch" tags in a map. If multiple conditions are hold, 
a tag written earlier is adopted (also useful to express time flow such as morning, 
noon, and night with different BGMs).

@param DefaultVolume
@desc Default volume for switched bgm without value specified (default: 90)
@default 90
@type number
@min 0
@max 100
@param DefaultPitch
@desc Default pitch for switched bgm without value specified (default: 100)
@default 100
@type number
@min 50
@max 150
@param DefaultPan
@desc Default pan for switched bgm without value specified (default: 0)
@default 0
@type number
@min -50
@max 50
@param DefaultPos
@desc Default start position for switched bgm without value specified (default: 0)
@default 0
@type number
@min 0
*/
(function () {
	const pluginName = "SoR_MapBGM_EventSwitch_MZ";
	const Param = PluginManager.parameters(pluginName);
	const DefaultVolume = Number(Param['DefaultVolume'] || 0);
	const DefaultPitch = Number(Param['DefaultPitch'] || 0);
	const DefaultPan = Number(Param['DefaultPan'] || 0);
	const DefaultPos = Number(Param['DefaultPos'] || 0);
	
    const SoR_BES_GM_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function(mapId) {
        SoR_BES_GM_setup.call(this, mapId);
	    this.switchbgm_flagID = [];
		this.switched_bgm = []; // switch bgm candidate array
        this.setMapBGMtags();
    }

    Game_Map.prototype.setMapBGMtags = function(){
		if($dataMap.note===undefined) return;
		//mapswitch tag
		const tag = /<(?:mapswitch):[ ]*(\d+),[ ]*([^,]*),?[ ]*(.*)?>/i;
		const tag_ = /<(?:BGMswitch):[ ]*(\d+),[ ]*([^,]*),?[ ]*(.*)?>/i;
		const tag2 = /<(?:BGMswitchCond):[ ]*(.*),[ ]*([^,]*),?[ ]*(.*)?>/i;
		const tag_opt = /([+,-]?\d+)?,?([+,-]?\d+)?,?([+,-]?\d+)?,?([+,-]?\d+)?/;
		const notes = $dataMap.note.split(/[\r\n]+/);
		for (let n = 0; n < notes.length; n++) {
			const line = notes[n];
			if (line.match(tag) || line.match(tag_)) {
				const ID = parseInt(RegExp.$1);
			    const switchbgm = {
					name: String(RegExp.$2),
					volume: DefaultVolume,
					pitch: DefaultPitch,
					pan: DefaultPan,
					pos: DefaultPos
				};

				const opt = RegExp.$3.trim();
				if(opt){
					if (opt.match(tag_opt)) {
						if(RegExp.$1) switchbgm.volume = parseInt(RegExp.$1);
						if(RegExp.$2) switchbgm.pitch = parseInt(RegExp.$2);
						if(RegExp.$3) switchbgm.pan = parseInt(RegExp.$3);
						if(RegExp.$4) switchbgm.pos = parseInt(RegExp.$4);
					}
				}

				this.switchbgm_flagID.push(ID);
				this.switched_bgm.push(switchbgm);
	  	    }
			else if (line.match(tag2)) {
				const cond = String(RegExp.$1);
			    const switchbgm = {
					name: String(RegExp.$2),
					volume: DefaultVolume,
					pitch: DefaultPitch,
					pan: DefaultPan,
					pos: DefaultPos
				};

				const opt = RegExp.$3.trim();
				if(opt){
					if (opt.match(tag_opt)) {
						if(RegExp.$1) switchbgm.volume = parseInt(RegExp.$1);
						if(RegExp.$2) switchbgm.pitch = parseInt(RegExp.$2);
						if(RegExp.$3) switchbgm.pan = parseInt(RegExp.$3);
						if(RegExp.$4) switchbgm.pos = parseInt(RegExp.$4);
					}
				}
				
				this.switchbgm_flagID.push(cond);
				this.switched_bgm.push(switchbgm);
	  	    }
		}
    }



	const SoR_BES_GM_autoplay = Game_Map.prototype.autoplay;
	Game_Map.prototype.autoplay = function() {
		if(this.switched_bgm && this.switched_bgm.length>0) this.SoR_switchedBGMplay();
		else SoR_BES_GM_autoplay.call(this);
	}
	
	//almost a clone of autoplay()
	Game_Map.prototype.SoR_switchedBGMplay = function() {
		if ($dataMap.autoplayBgm) {
			if ($gamePlayer.isInVehicle()) {
				$gameSystem.saveWalkingBgm2();
			} else { // conditional bgm play
				this.SoR_conditionalBGMplay();
			}
		}
		if ($dataMap.autoplayBgs) AudioManager.playBgs($dataMap.bgs);
	}

	Game_Map.prototype.SoR_conditionalBGMplay = function() {
		let bgmid = -1;
		const N_BGMcand = this.switched_bgm.length;
		for(let i=0; i<N_BGMcand;i++){
			if(checkBGMswitchFalg(this.switchbgm_flagID[i])){
				bgmid = i;
				break;
			}
		}
		if(bgmid==-1) AudioManager.playBgm($dataMap.bgm); //regular bgm on database
		else AudioManager.playBgm(this.switched_bgm[bgmid]);
	}

	Game_Temp.prototype.updateBGMonMap = function(){
		$gameMap.SoR_conditionalBGMplay();
	}


	function checkBGMswitchFalg(val){
		let flag=false;

		if(Number.isInteger(val)){
			if($gameSwitches.value(val)) flag=true;
		}
		else{
			if(SoR_Eval(val)) flag=true;
		}

		return flag;
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////
	function SoR_Eval(ev) {
		const sentence = "return (" + ev + ");";

		if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
		if(!$gameTemp.SoRTmp_script.has(sentence)){
			$gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
		}     
		const res = $gameTemp.SoRTmp_script.get(sentence)();
		return res;
	}
})();